import { test, expect } from '@playwright/test';

test('トップページが表示される', async ({ page }) => {
  // トップページにアクセス
  await page.goto('/');

  // ページタイトルを確認
  await expect(page).toHaveTitle(/自動テスト練習場/);
});

test('ボタンをクリックできる', async ({ page }) => {
  // トップページにアクセス
  await page.goto('/');

  // 練習を始めるリンクが表示されていることを確認
  const startLink = page.getByRole('link', { name: /練習を始める/ });
  await expect(startLink).toBeVisible();
});
